// Formats d'images supports :
//
// *.NEO - Neochrome & Neochrome Master - 320 x 200 x 16 couleurs
// *.PI1 - Degas & Degas Elite - 320 x 200 x 16 couleurs
// *.PI2 - Degas & Degas Elite - 640 x 200 x 4 couleurs
// *.PI3 - Degas & Degas Elite - 640 x 400 x 2 couleurs
// *.PC1 - Degas & Degas Elite compresse - 320 x 200 x 16 couleurs
// *.PC2 - Degas & Degas Elite compresse - 640 x 200 x 4 couleurs
// *.PC3 - Degas & Degas Elite compresse - 640 x 400 x 2 couleurs
// *.SPU - Spectrum 512 - 320 x 199 x 512 couleurs
// *.SPC - Spectrum 512 compresse - 320 x 199 x 512 couleurs
// *.SPS - Spectrum 512 smooshed - 320 x 199 x 512 couleurs
// *.ART - Art Director - 320 x 200 x 16 couleurs
// *.TNY - Tiny
// *.TN1 - Tiny - 320 x 200 x 16 couleurs
// *.TN2 - Tiny - 640 x 200 x 4 couleurs
// *.TN3 - Tiny - 640 x 400 x 2 couleurs
// *.DOO - Doodle - 640 x 400 x 2 couleurs
// *.MUR - C.O.L.R. Object Editor Mural - 320 x 200 x 16 couleurs
               
unit images;

interface

uses
  Windows, Controls, Forms, StdCtrls, Sysutils, Strutils,
  Classes, ExtCtrls, Graphics, tout, Menus;

type
  TVisu_images = class(TForm)
    Image1: TImage;
    Popupmenu_sps: TPopupMenu;
    change_Format_sps: TMenuItem;
    procedure FormDeactivate(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure change_Format_spsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

  TBGR = record B,G,R:byte; end;
  PRGB = ^TBGR;

procedure affiche_image(type_fichier:string; nomfichier:string; var buffer_fichier:array of byte); forward;

const
    palette_st_standard:array[0..15] of word=($7707,$0,$5505,$4404,$3303,$2202,$1101,$7007,$6006,$5005,$4004,$3003,$2002,$1001,$0700,0);

var
    Visu_images: TVisu_images;
    RGB: PRGB;
    image:array[0..15999] of word;
    image_compressee:array of byte;
    palette_compressee:array of word;

    palette_st:array[0..15] of word;
    palette_st_sp512:array[0..9551] of word;
    palette_pc:array[0..15] of TBGR;
    palette_pc_sp512:array[1..199,0..47] of TBGR;

    taille_donnees:longword;
    taille_pal:longword;

    format_sps:integer;

implementation

{$R *.dfm}
uses  traduction;

//Dcompression image DEGAS compresse *.PC1 - 320*200*16 couleurs
procedure decompression_image_pc1;
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    pointeur_buf:integer;
    ligne:integer;
    num_buf:integer;
    valeur:shortint;
    compteur:integer;
    i:integer;
    buf:array[0..39] of byte;
    ligne_plan:array[0..3,0..19] of word;

begin
    pointeur_sour:=0;
    pointeur_dest:=0;
    for ligne:=0 to 199 do
    begin
        for num_buf:=0 to 3 do
        begin
            pointeur_buf:=0;
            while pointeur_buf<40 do
            begin
                valeur:=image_compressee[pointeur_sour];
                inc(pointeur_sour);
                if valeur>=0 then       // Copie conforme des n+1 octets suivants
                begin
                    compteur:=valeur+1;
                    copymemory(@buf[pointeur_buf],@image_compressee[pointeur_sour],compteur);
                    inc(pointeur_sour,compteur);
                    inc(pointeur_buf,compteur);
                end
                else if (valeur>=-127) and (valeur<=-1) then        // Recopie -n+1 fois de l'octet suivant
                begin
                    compteur:=-valeur+1;
                    valeur:=image_compressee[pointeur_sour];
                    for i:=0 to compteur-1 do
                        buf[pointeur_buf+i]:=valeur;
                    inc(pointeur_sour);
                    inc(pointeur_buf,compteur);
                end;
            end;
            copymemory(@ligne_plan[num_buf,0],@buf[0],40);
        end;
        for i:=0 to 19 do
        begin
            for num_buf:=0 to 3 do
            begin
                image[pointeur_dest]:=ligne_plan[num_buf,i];
                inc(pointeur_dest);
            end;
        end;
    end;
end;


//Dcompression image DEGAS compresse *.PC2 - 640*200*4 couleurs
procedure decompression_image_pc2;
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    pointeur_buf:integer;
    ligne:integer;
    num_buf:integer;
    valeur:shortint;
    compteur:integer;
    i:integer;
    buf:array[0..79] of byte;
    ligne_plan:array[0..1,0..39] of word;

begin
    pointeur_sour:=0;
    pointeur_dest:=0;
    for ligne:=0 to 199 do
    begin
        for num_buf:=0 to 1 do
        begin
            pointeur_buf:=0;
            while pointeur_buf<80 do
            begin
                valeur:=image_compressee[pointeur_sour];
                inc(pointeur_sour);
                if valeur>=0 then       // Copie conforme des n+1 octets suivants
                begin
                    compteur:=valeur+1;
                    copymemory(@buf[pointeur_buf],@image_compressee[pointeur_sour],compteur);
                    inc(pointeur_sour,compteur);
                    inc(pointeur_buf,compteur);
                end
                else if (valeur>=-127) and (valeur<=-1) then        // Recopie -n+1 fois de l'octet suivant
                begin
                    compteur:=-valeur+1;
                    valeur:=image_compressee[pointeur_sour];
                    for i:=0 to compteur-1 do
                        buf[pointeur_buf+i]:=valeur;
                    inc(pointeur_sour);
                    inc(pointeur_buf,compteur);
                end;
            end;
            copymemory(@ligne_plan[num_buf,0],@buf[0],80);
        end;
        for i:=0 to 39 do
        begin
            for num_buf:=0 to 1 do
            begin
                image[pointeur_dest]:=ligne_plan[num_buf,i];
                inc(pointeur_dest);
            end;
        end;
    end;
end;


//Dcompression image DEGAS compresse *.PC3 - 640*400*2 couleurs
procedure decompression_image_pc3;
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    pointeur_buf:integer;
    ligne:integer;
    valeur:shortint;
    compteur:integer;
    i:integer;
    buf:array[0..79] of byte;
    ligne_plan:array[0..39] of word;

begin
    pointeur_sour:=0;
    pointeur_dest:=0;
    for ligne:=0 to 399 do
    begin
        pointeur_buf:=0;
        while pointeur_buf<80 do
        begin
            valeur:=image_compressee[pointeur_sour];
            inc(pointeur_sour);
            if valeur>=0 then       // Copie conforme des n+1 octets suivants
            begin
                compteur:=valeur+1;
                copymemory(@buf[pointeur_buf],@image_compressee[pointeur_sour],compteur);
                inc(pointeur_sour,compteur);
                inc(pointeur_buf,compteur);
            end
            else if (valeur>=-127) and (valeur<=-1) then        // Recopie -n+1 fois de l'octet suivant
            begin
                compteur:=-valeur+1;
                valeur:=image_compressee[pointeur_sour];
                for i:=0 to compteur-1 do buf[pointeur_buf+i]:=valeur;
                inc(pointeur_sour);
                inc(pointeur_buf,compteur);
            end;
        end;

        copymemory(@ligne_plan[0],@buf[0],80);
        for i:=0 to 39 do
        begin
            image[pointeur_dest]:=ligne_plan[i];
            inc(pointeur_dest);
        end;
    end;
end;


//Dcompression image Spectrum 512 compresse *.SPC - 320*199*512 couleurs
procedure decompression_image_sp512_spc;
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    valeur:shortint;
    compteur:integer;
    i:integer;
    j:integer;
    buf_image:array[0..31839] of byte;

begin
    pointeur_sour:=0;
    pointeur_dest:=0;
    repeat
        valeur:=image_compressee[pointeur_sour];
        inc(pointeur_sour);
        if valeur>=0 then       // Copie conforme des n+1 octets suivants
        begin
            compteur:=valeur+1;
            copymemory(@buf_image[pointeur_dest],@image_compressee[pointeur_sour],compteur);
            inc(pointeur_sour,compteur);
            inc(pointeur_dest,compteur);
        end
        else begin       // Sinon recopie -n+2 fois de l'octet suivant
            compteur:=-valeur+2;
            valeur:=image_compressee[pointeur_sour];
            inc(pointeur_sour);
            for i:=0 to compteur-1 do buf_image[pointeur_dest+i]:=valeur;
            inc(pointeur_dest,compteur);
        end;
    until  pointeur_dest>=31840;

    i:=80;  //Dpart  la ligne 1
    j:=0;
    repeat
        copymemory(@image[i],@buf_image[j],2);
        copymemory(@image[i+1],@buf_image[j+7960],2);
        copymemory(@image[i+2],@buf_image[j+15920],2);
        copymemory(@image[i+3],@buf_image[j+23880],2);
        inc(i,4);
        inc(j,2);
    until i>=16000;
end;


//Dcompression image Spectrum 512 compresse *.SPS - 320*199*512 couleurs
procedure decompression_image_sp512_sps;
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    valeur:byte;
    compteur:integer;
    buf_image:array[0..31839] of byte;
    i:integer;
    colonne:integer;
    ligne:integer;

begin
    pointeur_sour:=0;
    pointeur_dest:=0;
    repeat
        valeur:=image_compressee[pointeur_sour];
        inc(pointeur_sour);
        if valeur<=127 then       // Recopie n+3 fois de l'octet suivant
        begin
            compteur:=valeur+3;
            valeur:=image_compressee[pointeur_sour];
            inc(pointeur_sour);
            for i:=0 to compteur-1 do buf_image[pointeur_dest+i]:=valeur;
            inc(pointeur_dest,compteur);
        end
        else begin       // Copie conforme des n-128+1 octets suivants
            compteur:=valeur-127;
            copymemory(@buf_image[pointeur_dest],@image_compressee[pointeur_sour],compteur);
            inc(pointeur_sour,compteur);
            inc(pointeur_dest,compteur);
        end;
    until  pointeur_dest>=31840;

    if format_sps=0 then
    begin
        //Mise en forme pour format SPSLIDEX (Idem que pour *.SPC)
        pointeur_dest:=80;  //Dpart  la ligne 1
        pointeur_sour:=0;
        repeat
            copymemory(@image[pointeur_dest],@buf_image[pointeur_sour],2);
            copymemory(@image[pointeur_dest+1],@buf_image[pointeur_sour+7960],2);
            copymemory(@image[pointeur_dest+2],@buf_image[pointeur_sour+15920],2);
            copymemory(@image[pointeur_dest+3],@buf_image[pointeur_sour+23880],2);
            inc(pointeur_dest,4);
            inc(pointeur_sour,2);
        until pointeur_dest>=16000;
    end
    else begin
        //Mise en forme pour format ANISPEC
        pointeur_sour:=0;
        pointeur_dest:=0;
        for colonne:=0 to 19 do
        begin
            for ligne:=1 to 199 do
            begin
                //Plan 0
                image[pointeur_dest+ligne*80]:=buf_image[pointeur_sour];
                image[pointeur_dest+ligne*80]:=image[pointeur_dest+ligne*80]+
                        buf_image[pointeur_sour+199] shl 8;
                //Plan 1
                image[pointeur_dest+ligne*80+1]:=buf_image[pointeur_sour+7960];
                image[pointeur_dest+ligne*80+1]:=image[pointeur_dest+ligne*80+1]+
                        buf_image[pointeur_sour+7960+199] shl 8;
                //Plan 2
                image[pointeur_dest+ligne*80+2]:=buf_image[pointeur_sour+15920];
                image[pointeur_dest+ligne*80+2]:=image[pointeur_dest+ligne*80+2]+
                        buf_image[pointeur_sour+15920+199] shl 8;
                //Plan 3
                image[pointeur_dest+ligne*80+3]:=buf_image[pointeur_sour+23880];
                image[pointeur_dest+ligne*80+3]:=image[pointeur_dest+ligne*80+3]+
                        buf_image[pointeur_sour+23880+199] shl 8;

                inc(pointeur_sour);
            end;
            inc(pointeur_sour,199);
            inc(pointeur_dest,4);
        end;
    end;
end;


//Dcompression image TINY
procedure decompression_image_tiny;
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    pointeur_controle:integer;
    nb_controle:word;
    nb_data:word;
    valeur_controle:shortint;
    valeur_donnee:word;
    buf_image:array[0..31999] of byte;
    compteur:integer;
    i:integer;
    ligne:integer;
    colonne:integer;

begin
    copymemory(@nb_controle,@image_compressee[0],2);
    nb_controle:=mem_st_pc(nb_controle);
    copymemory(@nb_data,@image_compressee[2],2);
    nb_data:=mem_st_pc(nb_data);
    pointeur_controle:=4;
    pointeur_sour:=4+nb_controle;
    pointeur_dest:=0;

    //Dcompression
    repeat
        valeur_controle:=image_compressee[pointeur_controle];
        inc(pointeur_controle);

        if valeur_controle<0 then
        begin
            compteur:=-valeur_controle*2;
            copymemory(@buf_image[pointeur_dest],@image_compressee[pointeur_sour],compteur);
            inc(pointeur_dest,compteur);
            inc(pointeur_sour,compteur);
        end
        else if valeur_controle=0 then
        begin
            copymemory(@compteur,@image_compressee[pointeur_controle],2);
            compteur:=mem_st_pc(compteur);
            inc(pointeur_controle,2);
            copymemory(@valeur_donnee,@image_compressee[pointeur_sour],2);
            inc(pointeur_sour,2);
            for i:=0 to compteur-1 do
            begin
                copymemory(@buf_image[pointeur_dest],@valeur_donnee,2);
                inc(pointeur_dest,2);
            end;
        end
        else if valeur_controle=1 then
        begin
            copymemory(@compteur,@image_compressee[pointeur_controle],2);
            compteur:=mem_st_pc(compteur);
            inc(pointeur_controle,2);
            for i:=0 to compteur-1 do
            begin
                copymemory(@buf_image[pointeur_dest],@image_compressee[pointeur_sour],2);
                inc(pointeur_dest,2);
                inc(pointeur_sour,2);
            end;
        end
        else if valeur_controle>1 then
        begin
            compteur:=valeur_controle;
            copymemory(@valeur_donnee,@image_compressee[pointeur_sour],2);
            inc(pointeur_sour,2);
            for i:=0 to compteur-1 do
            begin
                copymemory(@buf_image[pointeur_dest],@valeur_donnee,2);
                inc(pointeur_dest,2);
            end;
        end;
    until pointeur_controle>=nb_controle+3;

    //Conversion
    pointeur_sour:=0;
    for colonne:=0 to 19 do
        for ligne:=0 to 199 do
        begin
            pointeur_dest:=ligne*80+colonne*4;
            copymemory(@image[pointeur_dest],@buf_image[pointeur_sour],2);
            copymemory(@image[pointeur_dest+1],@buf_image[pointeur_sour+8000],2);
            copymemory(@image[pointeur_dest+2],@buf_image[pointeur_sour+16000],2);
            copymemory(@image[pointeur_dest+3],@buf_image[pointeur_sour+24000],2);
            inc(pointeur_sour,2);
        end;
end;


//Dcompression palette Spectrum 512 d'un fichier *.SPC
procedure decompression_palette_sp512_spc;
var
    couleurs_actives:word;
    masque:word;
    num_couleur:integer;
    num_palette:integer;
    pointeur_sour:integer;
    pointeur_dest:integer;

begin
    pointeur_sour:=0;
    pointeur_dest:=0;

    for num_palette:=1 to 597 do
    begin
        masque:=1;
        couleurs_actives:=palette_compressee[pointeur_sour];
        couleurs_actives:=mem_st_pc(couleurs_actives);
        inc(pointeur_sour);

        for num_couleur:=0 to 15 do
        begin
            if ((couleurs_actives and masque)<>0) and (num_couleur in [1..14]) then
            begin
                palette_st_sp512[pointeur_dest]:=palette_compressee[pointeur_sour];
                inc(pointeur_sour);
            end
            else palette_st_sp512[pointeur_dest]:=0;

            inc(pointeur_dest);
            masque:=masque shl 1;
        end;
    end;
end;


//Dcompression palette Spectrum 512 d'un fichier *.SPS
procedure decompression_palette_sp512_sps;
var
    couleurs_actives:array [1..14] of boolean;
    num_couleur:integer;
    num_palette:integer;
    pointeur_sour:integer;
    pointeur_dest:integer;
    palette_sps:array of boolean;
    taille_palette_compressee:integer;
    taille_palette_sps:integer;
    couleur:integer;

begin
    taille_palette_compressee:=length(palette_compressee);
    taille_palette_sps:=taille_palette_compressee shl 4;
    setlength(palette_sps,taille_palette_sps);

    //Remplissage tableau de palettes
    pointeur_sour:=0;
    pointeur_dest:=0;
    repeat
        couleur:=mem_st_pc(palette_compressee[pointeur_sour]);
        if (couleur and 1)<>0 then palette_sps[pointeur_dest+15]:=true;
        if (couleur and 2)<>0 then palette_sps[pointeur_dest+14]:=true;
        if (couleur and 4)<>0 then palette_sps[pointeur_dest+13]:=true;
        if (couleur and 8)<>0 then palette_sps[pointeur_dest+12]:=true;
        if (couleur and 16)<>0 then palette_sps[pointeur_dest+11]:=true;
        if (couleur and 32)<>0 then palette_sps[pointeur_dest+10]:=true;
        if (couleur and 64)<>0 then palette_sps[pointeur_dest+9]:=true;
        if (couleur and 128)<>0 then palette_sps[pointeur_dest+8]:=true;
        if (couleur and 256)<>0 then palette_sps[pointeur_dest+7]:=true;
        if (couleur and 512)<>0 then palette_sps[pointeur_dest+6]:=true;
        if (couleur and 1024)<>0 then palette_sps[pointeur_dest+5]:=true;
        if (couleur and 2048)<>0 then palette_sps[pointeur_dest+4]:=true;
        if (couleur and 4096)<>0 then palette_sps[pointeur_dest+3]:=true;
        if (couleur and 8192)<>0 then palette_sps[pointeur_dest+2]:=true;
        if (couleur and 16384)<>0 then palette_sps[pointeur_dest+1]:=true;
        if (couleur and 32768)<>0 then palette_sps[pointeur_dest+0]:=true;
        inc(pointeur_sour);
        inc(pointeur_dest,16);
    until pointeur_sour>=taille_palette_compressee;

    //Dcompression palette
    pointeur_sour:=0;
    pointeur_dest:=0;
    for num_palette:=1 to 597 do
    begin
        //Lecture de la table des couleurs actives de la palette
        for num_couleur:=1 to 14 do couleurs_actives[num_couleur]:=palette_sps[pointeur_sour+num_couleur-1];
        inc(pointeur_sour,14);

        //Premire couleur toujours  0
        palette_st_sp512[pointeur_dest]:=0;
        inc(pointeur_dest);

        //Lecture des 14 couleurs de la palette
        for num_couleur:=1 to 14 do
        begin
            if couleurs_actives[num_couleur] then
            begin
                couleur:=0;
                if palette_sps[pointeur_sour+0] then couleur:=couleur or 1024;
                if palette_sps[pointeur_sour+1] then couleur:=couleur or 512;
                if palette_sps[pointeur_sour+2] then couleur:=couleur or 256;
                if palette_sps[pointeur_sour+3] then couleur:=couleur or 64;
                if palette_sps[pointeur_sour+4] then couleur:=couleur or 32;
                if palette_sps[pointeur_sour+5] then couleur:=couleur or 16;
                if palette_sps[pointeur_sour+6] then couleur:=couleur or 4;
                if palette_sps[pointeur_sour+7] then couleur:=couleur or 2;
                if palette_sps[pointeur_sour+8] then couleur:=couleur or 1;
                inc(pointeur_sour,9);
                palette_st_sp512[pointeur_dest]:=mem_st_pc(couleur);
            end
            else palette_st_sp512[pointeur_dest]:=0;

            inc(pointeur_dest);
        end;

        //Dernire couleur toujours  0
        palette_st_sp512[pointeur_dest]:=0;
        inc(pointeur_dest);
    end;
    setlength(palette_sps,0);
end;


//Conversion palette ST 4 bits (16 couleurs) en palette PC 24 bits (16777214 couleurs)
procedure conversion_palette_16_couleurs;
var
    i:word;
    rouge:byte;
    vert:byte;
    bleu:byte;
    temp:word;

begin
    for i:=0 to 15 do
    begin
        temp:=mem_st_pc(palette_st[i]);
        bleu:=temp and $000f;
        vert:=(temp and $00f0) shr 4;
        rouge:=(temp and $0f00) shr 8;

        // Conversion couleur de 4 bits vers 24 bits
        palette_pc[i].R :=rouge shl 5;
        palette_pc[i].G :=vert shl 5;
        palette_pc[i].B :=bleu shl 5;
    end;
end;


//Conversion image ST basse rsolution vers PC (320 x 200)
procedure conversion_image_320x200x16_couleurs;
var
    x: Word;
    y: Word;
    adr:integer;
    num_couleur:integer;
    point:integer;
    val_plan0:integer;
    val_plan1:integer;
    val_plan2:integer;
    val_plan3:integer;
    plan0:word;
    plan1:word;
    plan2:word;
    plan3:word;
    masque:word;

begin
    //Redimensionnement de la fentre
    Visu_images.Width :=325;
    Visu_images.Height:=225;
    Visu_images.image1.Width:=320;
    Visu_images.image1.Height:=200;
    Visu_images.image1.Picture.Bitmap.Width:=320;
    Visu_images.image1.Picture.Bitmap.Height:=200;

    adr:=0;

    for y := 0 to 199 do
    begin
        rgb:=Visu_images.image1.Picture.Bitmap.ScanLine[y];
        x:=0;
        while x<319 do
        begin
            masque:=$8000;
            //Lecture des 4 plans de 16 pixels
            plan0:=mem_st_pc(image[adr]);
            plan1:=mem_st_pc(image[adr+1]);
            plan2:=mem_st_pc(image[adr+2]);
            plan3:=mem_st_pc(image[adr+3]);

            for point:=15 downto 0 do
            begin
                val_plan0:=(plan0 and masque) shr point;
                val_plan1:=((plan1 and masque) shr point) shl 1;
                val_plan2:=((plan2 and masque) shr point) shl 2;
                val_plan3:=((plan3 and masque) shr point) shl 3;
                num_couleur:=val_plan0+val_plan1+val_plan2+val_plan3;
                rgb^.R:=palette_pc[num_couleur].r;
                rgb^.G:=palette_pc[num_couleur].g;
                rgb^.B:=palette_pc[num_couleur].b;
                masque:=masque shr 1;
                inc(rgb);
            end;

            //Passage aux 16 points suivants
            inc(x,16);
            inc(adr,4);
        end;
    end;
end;


//Conversion image ST moyenne rsolution vers PC (640 x 200)
procedure conversion_image_640x200x4_couleurs;
var
    x: Word;
    y: Word;
    adr:integer;
    num_couleur:integer;
    point:integer;
    val_plan0:integer;
    val_plan1:integer;
    plan0:word;
    plan1:word;
    masque:word;

begin
    //Redimensionnement de la fentre
    Visu_images.Width :=645;
    Visu_images.Height:=225;
    Visu_images.image1.Width:=640;
    Visu_images.image1.Height:=200;
    Visu_images.image1.Picture.Bitmap.Width:=640;
    Visu_images.image1.Picture.Bitmap.Height:=200;

    adr:=0;

    for y := 0 to 199 do
    begin
        rgb:=Visu_images.image1.Picture.Bitmap.ScanLine[y];
        x:=0;
        while x<639 do
        begin
            masque:=$8000;
            //Lecture des 2 plans de 16 pixels
            plan0:=mem_st_pc(image[adr]);
            plan1:=mem_st_pc(image[adr+1]);

            for point:=15 downto 0 do
            begin
                val_plan0:=(plan0 and masque) shr point;
                val_plan1:=((plan1 and masque) shr point) shl 1;
                num_couleur:=val_plan0+val_plan1;
                rgb^.R:=palette_pc[num_couleur].r;
                rgb^.G:=palette_pc[num_couleur].g;
                rgb^.B:=palette_pc[num_couleur].b;
                masque:=masque shr 1;
                inc(rgb);
            end;

            //Passage aux 16 points suivants
            inc(x,16);
            inc(adr,2);
        end;
    end;
end;


//Conversion image ST haute rsolution vers PC (640 x 400)
procedure conversion_image_640x400x2_couleurs;
var
    x: Word;
    y: Word;
    adr:integer;
    num_couleur:integer;
    point:integer;
    plan0:word;
    masque:word;

begin
    //Redimensionnement de la fentre
    Visu_images.Width :=645;
    Visu_images.Height:=425;
    Visu_images.image1.Width:=640;
    Visu_images.image1.Height:=400;
    Visu_images.image1.Picture.Bitmap.Width:=640;
    Visu_images.image1.Picture.Bitmap.Height:=400;

    adr:=0;

    for y := 0 to 399 do
    begin
        rgb:=Visu_images.image1.Picture.Bitmap.ScanLine[y];
        x:=0;
        while x<639 do
        begin
            masque:=$8000;
            //Lecture de 16 pixels
            plan0:=mem_st_pc(image[adr]);

            for point:=15 downto 0 do
            begin
                num_couleur:=(plan0 and masque) shr point;
                rgb^.R:=palette_pc[num_couleur].r;
                rgb^.G:=palette_pc[num_couleur].g;
                rgb^.B:=palette_pc[num_couleur].b;
                masque:=masque shr 1;
                inc(rgb);
            end;

            //Passage aux 16 points suivants
            inc(x,16);
            inc(adr);
        end;
    end;
end;


//Conversion palette Spectrum 512 en palette PC 24 bits (16777214 couleurs)
//3 palettes de 16 couleurs par lignes soit 48 couleurs par lignes. Lignes utilises : de 1  199
procedure conversion_palette_sp512;
var
    couleur:integer;
    ligne:integer;
    index:integer;
    rouge:byte;
    vert:byte;
    bleu:byte;
    temp:word;

begin
    for ligne:=1 to 199 do
    begin
        for couleur:=0 to 47 do
        begin
            index:=couleur+(ligne-1)*48;
            temp:=mem_st_pc(palette_st_sp512[index]);
            bleu:=temp and $000f;
            vert:=(temp and $00f0) shr 4;
            rouge:=(temp and $0f00) shr 8;

            // Conversion couleur de 4 bits vers 24 bits
            palette_pc_sp512[ligne,couleur].R :=rouge shl 5;
            palette_pc_sp512[ligne,couleur].G :=vert shl 5;
            palette_pc_sp512[ligne,couleur].B :=bleu shl 5;
        end;
    end;
end;


//Conversion image Spectrum 512 vers PC (320 x 199)
procedure conversion_image_sp512;
var
    x:integer;
    y:integer;
    adr:integer;
    num_couleur:integer;
    point:integer;
    val_plan0:integer;
    val_plan1:integer;
    val_plan2:integer;
    val_plan3:integer;
    calcul:integer;

    plan0:word;
    plan1:word;
    plan2:word;
    plan3:word;
    masque:word;

begin
    //Redimensionnement de la fentre
    Visu_images.Width :=325;
    Visu_images.Height:=225;
    Visu_images.image1.Width:=320;
    Visu_images.image1.Height:=200;
    Visu_images.image1.Picture.Bitmap.Width:=320;
    Visu_images.image1.Picture.Bitmap.Height:=200;

    //Premire ligne noire
    rgb:=Visu_images.image1.Picture.Bitmap.ScanLine[0];
    for x:=0 to 319 do
    begin
        rgb^.R:=0;
        rgb^.G:=0;
        rgb^.B:=0;
        inc(rgb);
    end;

    //Dpart  la ligne 1
    adr:=80;
    for y := 1 to 199 do
    begin
        rgb:=Visu_images.image1.Picture.Bitmap.ScanLine[y];
        x:=0;
        while x<320 do
        begin
            masque:=$8000;
            //Lecture des 4 plans de 16 pixels
            plan0:=mem_st_pc(image[adr]);
            plan1:=mem_st_pc(image[adr+1]);
            plan2:=mem_st_pc(image[adr+2]);
            plan3:=mem_st_pc(image[adr+3]);

            for point:=15 downto 0 do
            begin
                val_plan0:=(plan0 and masque) shr point;
                val_plan1:=((plan1 and masque) shr point) shl 1;
                val_plan2:=((plan2 and masque) shr point) shl 2;
                val_plan3:=((plan3 and masque) shr point) shl 3;
                num_couleur:=val_plan0+val_plan1+val_plan2+val_plan3;

                //Recherche de la couleur  afficher parmi les 48 de la ligne
                calcul:=10*num_couleur;
                if odd(num_couleur) then dec(calcul,5)
                    else inc(calcul);

                if (x>=calcul) and (x<calcul+160) then inc(num_couleur,16)
                    else if (x>=calcul+160) then inc(num_couleur,32);

                //Affichage du point
                rgb^.R:=palette_pc_sp512[y,num_couleur].r;
                rgb^.G:=palette_pc_sp512[y,num_couleur].g;
                rgb^.B:=palette_pc_sp512[y,num_couleur].b;
                masque:=masque shr 1;
                inc(rgb);
                inc(x);
            end;

            //Passage aux 16 points suivants
            inc(adr,4);
        end;
    end;
end;


//Affichage image
procedure affiche_image(type_fichier:string; nomfichier:string; var buffer_fichier:array of byte);
var
    w_data:word;
    b_data:byte;

begin
    Visu_images.image1.Picture.Bitmap.Create;
    Visu_images.image1.Picture.Bitmap.HandleType:=bmDIB;
    Visu_images.image1.Picture.Bitmap.PixelFormat:=pf24bit;

    //Effacement du buffer image
    fillChar(image,32000,0);

    //Affichage nom du fichier dans tire de la fentre
    Visu_images.Caption:=extraire_nom_fichier(nomfichier);    

    if type_fichier='NEO' then
    begin
        // image *.NEO - Neochrome & Neochrome Master - 320 x 200 x 16 couleurs
        taille_donnees:=length(buffer_fichier)-128;
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@palette_st[0],@buffer_fichier[4],32);
        copymemory(@image[0],@buffer_fichier[128],taille_donnees);
        conversion_palette_16_couleurs;
        conversion_image_320x200x16_couleurs;
    end
    else
    if type_fichier='PI1' then
    begin
        // image *.PI1 - Degas & Degas Elite - 320 x 200 x 16 couleurs
        taille_donnees:=(length(buffer_fichier)-34);
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@palette_st[0],@buffer_fichier[2],32);
        copymemory(@image[0],@buffer_fichier[34],taille_donnees);
        conversion_palette_16_couleurs;
        conversion_image_320x200x16_couleurs;
    end
    else
    if type_fichier='PI2' then
    begin
        // image *.PI2 - Degas & Degas Elite - 640 x 200 x 4 couleurs
        taille_donnees:=length(buffer_fichier)-34;
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@palette_st[0],@buffer_fichier[2],32);
        copymemory(@image[0],@buffer_fichier[34],taille_donnees);
        conversion_palette_16_couleurs;
        conversion_image_640x200x4_couleurs;
    end
    else
    if type_fichier='PI3' then
    begin
        // image *.PI3 - Degas & Degas Elite - 640 x 400 x 2 couleurs
        taille_donnees:=length(buffer_fichier)-34;
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@palette_st[0],@buffer_fichier[2],32);
        copymemory(@image[0],@buffer_fichier[34],taille_donnees);
        conversion_palette_16_couleurs;
        conversion_image_640x400x2_couleurs;
    end
    else
    if type_fichier='PC1' then
    begin
        // image *.PC1 - Degas & Degas Elite compresse - 320 x 200 x 16 couleurs
        taille_donnees:=length(buffer_fichier)-34;
        if taille_donnees>32000 then taille_donnees:=32000;
        setlength(image_compressee,taille_donnees);
        copymemory(@palette_st[0],@buffer_fichier[2],32);
        copymemory(@image_compressee[0],@buffer_fichier[34],taille_donnees);
        decompression_image_pc1;
        conversion_palette_16_couleurs;
        conversion_image_320x200x16_couleurs;
    end
    else
    if type_fichier='PC2' then
    begin
        // image *.PC2 - Degas & Degas Elite compresse - 640 x 200 x 4 couleurs
        taille_donnees:=length(buffer_fichier)-34;
        if taille_donnees>32000 then taille_donnees:=32000;
        setlength(image_compressee,taille_donnees);
        copymemory(@palette_st[0],@buffer_fichier[2],32);
        copymemory(@image_compressee[0],@buffer_fichier[34],taille_donnees);
        decompression_image_pc2;
        conversion_palette_16_couleurs;
        conversion_image_640x200x4_couleurs;
    end
    else
    if type_fichier='PC3' then
    begin
        // image *.PC3 - Degas & Degas Elite compresse - 640 x 400 x 2 couleurs
        taille_donnees:=length(buffer_fichier)-34;
        if taille_donnees>32000 then taille_donnees:=32000;
        setlength(image_compressee,taille_donnees);
        copymemory(@palette_st[0],@buffer_fichier[2],32);
        copymemory(@image_compressee[0],@buffer_fichier[34],taille_donnees);
        decompression_image_pc3;
        conversion_palette_16_couleurs;
        conversion_image_640x400x2_couleurs;
    end
    else
    if type_fichier='SPU' then
    begin
        // image *.SPU - Spectrum 512 - 320 x 199 x 512 couleurs
        copymemory(@image[0],@buffer_fichier[0],32000);
        copymemory(@palette_st_sp512[0],@buffer_fichier[32000],19104);
        conversion_palette_sp512;
        conversion_image_sp512;
    end
    else
    if type_fichier='SPC' then
    begin
        // image *.SPC - Spectrum 512 compresse - 320 x 199 x 512 couleurs
        copymemory(@w_data,@buffer_fichier[4],2);
        taille_donnees:=mem_st_pc(w_data);
        taille_donnees:=taille_donnees shl 16;
        copymemory(@w_data,@buffer_fichier[6],2);
        taille_donnees:=taille_donnees+mem_st_pc(w_data);
        copymemory(@w_data,@buffer_fichier[8],2);
        taille_pal:=mem_st_pc(w_data);
        taille_pal:=taille_pal shl 16;
        copymemory(@w_data,@buffer_fichier[10],2);
        taille_pal:=taille_pal+mem_st_pc(w_data);

        setlength(image_compressee,taille_donnees);
        setlength(palette_compressee,taille_pal);

        copymemory(@image_compressee[0],@buffer_fichier[12],taille_donnees);
        copymemory(@palette_compressee[0],@buffer_fichier[12+taille_donnees],taille_pal);

        decompression_palette_sp512_spc;
        conversion_palette_sp512;
        decompression_image_sp512_spc;
        conversion_image_sp512;
    end
    else
    if type_fichier='SPS' then
    begin
        // image *.SPS - Spectrum 512 smooshed - 320 x 199 x 512 couleurs
        copymemory(@w_data,@buffer_fichier[4],2);
        taille_donnees:=mem_st_pc(w_data);
        taille_donnees:=taille_donnees shl 16;
        copymemory(@w_data,@buffer_fichier[6],2);
        taille_donnees:=taille_donnees+mem_st_pc(w_data);
        copymemory(@w_data,@buffer_fichier[8],2);
        taille_pal:=mem_st_pc(w_data);
        taille_pal:=taille_pal shl 16;
        copymemory(@w_data,@buffer_fichier[10],2);
        taille_pal:=taille_pal+mem_st_pc(w_data);

        setlength(image_compressee,taille_donnees);
        setlength(palette_compressee,taille_pal);

        copymemory(@image_compressee[0],@buffer_fichier[12],taille_donnees);
        copymemory(@palette_compressee[0],@buffer_fichier[12+taille_donnees],taille_pal);

        decompression_palette_sp512_sps;
        conversion_palette_sp512;
        decompression_image_sp512_sps;
        conversion_image_sp512;
    end
    else
    if type_fichier='ART' then
    begin
        // image *.ART - Art Director - 320 x 200 x 16 couleurs
        taille_donnees:=length(buffer_fichier)-32;
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@image[0],@buffer_fichier[0],taille_donnees);
        copymemory(@palette_st[0],@buffer_fichier[taille_donnees],32);
        conversion_palette_16_couleurs;
        conversion_image_320x200x16_couleurs;
    end
    else
    if leftstr(type_fichier,2)='TN' then
    begin
        //Image TNY, TN1, TN2 ou TN3 - Tiny
        b_data:=image[0];
        if b_data>2 then
        begin
            copymemory(@palette_st[0],@buffer_fichier[5],32);
            taille_donnees:=length(buffer_fichier)-37;
            setlength(image_compressee,taille_donnees);
            copymemory(@image_compressee[0],@buffer_fichier[37],taille_donnees);
        end else
        begin
            copymemory(@palette_st[0],@buffer_fichier[1],32);
            taille_donnees:=length(buffer_fichier)-33;
            setlength(image_compressee,taille_donnees);
            copymemory(@image_compressee[0],@buffer_fichier[33],taille_donnees);
        end;

        conversion_palette_16_couleurs;
        decompression_image_tiny;

        if (type_fichier='TN1') or ((type_fichier='TNY') and (b_data=0) or (b_data=3)) then
        begin
            // image *.TN1 - Tiny - 320 x 200 x 16 couleurs
            conversion_image_320x200x16_couleurs;
        end
        else if (type_fichier='TN2') or ((type_fichier='TNY') and (b_data=1) or (b_data=4)) then
        begin
            // image *.TN2 - Tiny - 640 x 200 x 4 couleurs
            conversion_image_640x200x4_couleurs;
        end
        else if (type_fichier='TN3') or ((type_fichier='TNY') and (b_data=2) or (b_data=5)) then
        begin
            // image *.TN3 - Tiny - 640 x 400 x 2 couleurs
            conversion_image_640x400x2_couleurs;
        end;
    end
    else
    if type_fichier='DOO' then
    begin
        // image *.DOO - Doodle - 640 x 400 x 2 couleurs
        taille_donnees:=length(buffer_fichier);
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@image[0],@buffer_fichier[0],taille_donnees);
        copymemory(@palette_st[0],@palette_st_standard[0],32);
        conversion_palette_16_couleurs;
        conversion_image_640x400x2_couleurs;
    end
    else
    if type_fichier='MUR' then
    begin
        // image *.MUR - C.O.L.R. Object Editor Mural - 320 x 200 x 16 couleurs
        taille_donnees:=length(buffer_fichier);
        if taille_donnees>32000 then taille_donnees:=32000;
        copymemory(@image[0],@buffer_fichier[0],taille_donnees);
        copymemory(@palette_st[0],@palette_st_standard[0],32);
        conversion_palette_16_couleurs;
        conversion_image_320x200x16_couleurs;
    end;
end;


//Fermeture de la fentre
procedure TVisu_images.FormDeactivate(Sender: TObject);
begin
    setlength(image_compressee,0);
    setlength(palette_compressee,0);
    visu_images.image1.Picture.Bitmap.FreeImage;
    close;
end;


//Affichage du menu Popup  l'emplacement de la souris dans la fentre si fichier SPS
procedure TVisu_images.Image1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    if Button = mbRight then
        if uppercase(extraire_type_fichier(visu_images.Caption))='SPS' then
            Popupmenu_sps.Popup(mouse.cursorpos.x,mouse.cursorpos.y);
end;


//Changement de format d'affichage d'une impae Spectrum512 Smooshed- SPSLIDEX<->ANISPEC
procedure TVisu_images.change_Format_spsClick(Sender: TObject);
begin
    format_sps:=format_sps xor 1;
    decompression_palette_sp512_sps;
    conversion_palette_sp512;
    decompression_image_sp512_sps;
    conversion_image_sp512;
    image1.Refresh;
end;


//Traduction des textes
procedure TVisu_images.FormCreate(Sender: TObject);
begin
    traduction_textes_images;
end;

end.

